// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : intro.cpp
// Date           : February 2008
//
// Description    : This file defines the CIntro class responsible for
//                  handling the introductory splash screen that appears
//                  just before the main menu GUI.  Once instantiated, Update()
//                  must be called within the main game loop while the intro
//                  is active.  Close() is used to determine if any key (or
//                  the LMB) has been pressed.  At which time, the application
//                  can delete CIntro and create a new Menu GUI.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once

// ///////////////////////////////////////////////////////////////////////////
// HEADERS (#include)
// ///////////////////////////////////////////////////////////////////////////
#include "global.h"
#include "GameState.h"



class CIntro : public GameState
{

  protected:

    bool            m_SpeechStarted[3];


    bool            closeIntro;     // Close intro flag
    bool            clickLeft;      // Used for "active-low" button pressing
    bool            m_FirstFrameDisplayed;
    float           m_IntroStateTime;


    void            RenderText( const std::string& Text, int X, int Y, float StartTime, float EndTime );
    void            RenderCursor( int X, int Y, float StartTime, float EndTime );


  public:

    CIntro();
    ~CIntro();


    void            Render();

    void            Update();
    void            UpdateTimed( const float ElapsedTime );
    bool            Close();


};

